#version 330 core

// Input vertex data, different for all executions of this shader.
layout(location = 0) in vec3 vertexPosition_modelspace;
// Notice that the "1" here equals the "1" in glVertexAttribPointer
layout(location = 1) in vec3 vertexColor;
layout(location = 2) in vec2 textureCoords;

// Values that stay constant for the whole mesh.
uniform mat4 mvp;
// Output data ; will be interpolated for each fragment.
out vec2 texCoord;

void main(){
	// Output position of the vertex, in clip space : mvp * position
	gl_Position = mvp * vec4(vertexPosition_modelspace,1);
    texCoord = textureCoords;
}
