#version 330 core

in vec3 in_position;
in vec2 in_texture;


// Values that stay constant for the whole mesh.
uniform mat4 pvm_mat;

// Output data ; will be interpolated for each fragment.
out vec2 texCoord;

void main(){
	// Output position of the vertex, in clip space : mvp * position
	gl_Position = pvm_mat * vec4(in_position, 1.0);
	
    texCoord = in_texture;
}