#version 330 core

in vec4 in_position;
in vec3 in_normal;
in vec3 in_color;

// Values that stay constant for the whole mesh.
uniform mat4 pvm_mat;
//Normal matrix
uniform mat4 normal_mat;
// Output data
out vec3 out_color;
out vec3 out_normal;

void main(){
	// Output position of the vertex, in clip space : mvp * position
	gl_Position = pvm_mat * vec4(in_position);

	vec4 newNormal = vec4(in_normal, 1);
	newNormal = normal_mat * newNormal;
	out_normal = vec3(newNormal);

    out_color = in_color;
}