#version 330 core

in vec4 in_position;
in vec3 in_color;

// Values that stay constant for the whole mesh.
uniform mat4 pvm_mat;
// Output data ; will be interpolated for each fragment.
out vec3 fragmentColor;

void main()
{
	// Output position of the vertex, in clip space : mvp * position
	gl_Position = pvm_mat * in_position;
	// The color of each vertex will be interpolated
    // to produce the color of each fragment
    fragmentColor = in_color;
}