#version 330 core

// input vectors
in vec4 in_position;
in vec3 in_normal;
in vec2 in_texture;

// Values that stay constant for the whole mesh.
uniform mat4 model_view; // Model to World
uniform mat4 projection; // MVP
uniform vec3 in_camera; // cam position
//Normal matrix
uniform mat4 normal_mat; // Model to world inverse transpose (normal matrix)

// Output data ; will be interpolated for each fragment.
//out vec2 texCoord;
out vec3 out_normal;
out vec3 eye;

// reflected vector
//out vec3 reflected;

void main(){
	// Output position of the vertex, in clip space : mvp * position
	gl_Position =  projection*in_position;
	// calculate normals
	out_normal = normalize(vec3(normal_mat* vec4(in_normal, 1.0f)));
	
	vec4 tmp = model_view*(vec4(in_camera,1)- in_position);
	vec3 positionW = tmp.xyz;
	// set texture coords
    //texCoord = in_texture;

	// get vertex pos in eye coordinates
	eye = normalize(positionW);
}