#version 150

uniform mat4 modelViewProjectionMatrix;
uniform mat4 modelViewMatrix;

in vec3 inPosition;

void main(void)
{
	gl_Position = modelViewProjectionMatrix * vec4(inPosition, 1.0);

	vec4 lightViewPos = modelViewMatrix * vec4(inPosition, 1.0);
	vec3 lightViewPosInh = lightViewPos.xyz/lightViewPos.w;
	
	gl_PointSize = 250.0 / length(lightViewPosInh);
}