#version 330 core

layout(triangles) in;
layout(triangle_strip, max_vertices = 18) out;

uniform mat4 cubeMapMatrices[6];

out vec4 vertexWorldPosition;

void main()
{
	for(int layer = 0; layer < 6; layer++)
	{
		gl_Layer = layer;
		for(int i = 0; i < 3; i++)
		{
			gl_Position = cubeMapMatrices[layer] * gl_in[i].gl_Position;
			vertexWorldPosition = gl_in[i].gl_Position;
			EmitVertex();
		}
		EndPrimitive();
	}
}