#version 330 core

uniform vec3 lightWorldPosition;
uniform float farPlane;

in vec4 vertexWorldPosition;

void main()
{
	vec3 fragmentWorldPosition = vertexWorldPosition.xyz/vertexWorldPosition.w;

	float worldDistance = distance(fragmentWorldPosition, lightWorldPosition); 

	float worldDistanceNormalized = worldDistance / farPlane; 

	gl_FragDepth = worldDistanceNormalized;
}