#version 330 core

uniform mat4 modelViewProjectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;
uniform mat4 invTranspModelViewMatrix;

uniform vec3 pointLightWorldPosition;

uniform mat4 directionalModelShadowMapTextureMatrix;
 
in vec3 inPosition;
in vec3 inNormal;
in vec4 inColor;
in vec2 inTexCoord;

out vec4 vertexViewPosition;
out vec3 vertexViewNormal;
out vec4 vertexColor;
out vec2 vertexTexCoord;

out vec4 vertexDirectionalSMTexCoord;
out vec3 vertexPointLightWorldDirection;

out vec4 voutColor;

void main(void)
{
	vec4 vertex = vec4(inPosition, 1.0);
	gl_Position = modelViewProjectionMatrix * vertex;
	
	
	vertexViewPosition = modelViewMatrix * vertex;
	vertexViewNormal = (invTranspModelViewMatrix * vec4(inNormal, 0.0)).xyz;
	vertexColor = inColor;
	vertexTexCoord = inTexCoord;

	vertexDirectionalSMTexCoord = directionalModelShadowMapTextureMatrix * vertex;

	vec4 vertexWorldPositionHomo =  modelMatrix * vertex;
	vec3 vertexWorldPosition = vertexWorldPositionHomo.xyz/vertexWorldPositionHomo.w;
	vertexPointLightWorldDirection = pointLightWorldPosition - vertexWorldPosition;	
}