#version 150

uniform mat4 modelLightViewProjectionMatrix;
uniform mat4 modelMatrix;

in vec3 inPosition;
in vec3 inNormal;

out vec4 vertexWorldPosition;

void main(void)
{
	float vertexNormalOffset = 0.05;
	vec4 vertex = vec4(inPosition + inNormal * vertexNormalOffset, 1.0);

	gl_Position = modelLightViewProjectionMatrix * vertex;
	vertexWorldPosition = modelMatrix * vertex;
}