#version 150

uniform sampler2D fboBuffer;
uniform sampler2D sceneTex;

in vec2 vertexTexCoord;

out vec4 outColor1;

// inspired by http://prideout.net/archive/bloom/

void main(void)
{
	int lod = 2;
	
	ivec2 fullTexDim = textureSize(fboBuffer, 0);	
	float pixelStep = 1.0 / fullTexDim.y * pow(2f, lod);

	vec3 colorSum = vec3(0);
	
	vec2 sampleTexCoord = vertexTexCoord;
	
	vec2 yOffset = vec2(0, pixelStep * 1.2);

	colorSum += texture(fboBuffer, sampleTexCoord - yOffset).xyz * 5;
	colorSum += texture(fboBuffer, sampleTexCoord).xyz * 6;		
	colorSum += texture(fboBuffer, sampleTexCoord + yOffset).xyz * 5;

	colorSum /= 16;
	
	colorSum += texture(sceneTex, vertexTexCoord).xyz;
		
	outColor1 = vec4(colorSum, 1);	
}