#version 150

uniform sampler2D fboBuffer;

in vec2 vertexTexCoord;

out vec4 outColor1;

// inspired by http://prideout.net/archive/bloom/

void main(void)
{
	int lod = 2;

	ivec2 texDim = textureSize(fboBuffer, lod);
	float pixelStep = 1.0 / texDim.x;

	vec3 colorSum = vec3(0);	

	vec2 sampleTexCoord = vertexTexCoord;
	
	vec2 xOffset = vec2(pixelStep * 1.2, 0);

	colorSum += textureLod(fboBuffer, sampleTexCoord - xOffset, lod).xyz * 5;
	colorSum += textureLod(fboBuffer, sampleTexCoord, lod).xyz * 6;		
	colorSum += textureLod(fboBuffer, sampleTexCoord + xOffset, lod).xyz * 5;

	colorSum /= 16;
		
	outColor1 = vec4(colorSum, 1);
}