varying vec4 pos;
varying mat4 texMat;
varying mat4 texMat1;
varying mat4 texMat2;
varying mat4 texMat3;

varying vec4 passcolor;
varying vec3 lightDirTransformed;
varying vec3 viewingDirTransformed;


varying vec3 tangent;
varying vec3 binormal;
varying vec3 normalW;

varying vec3 lightDirection;
varying vec3 viewingDirection;

uniform float3 lightpos; //light position
uniform float3 viewingdir; //viewing direction 

void main() {

	
	
	gl_FrontColor = gl_Color;
	passcolor = gl_Color;
			
	gl_Position = ftransform();
	
	pos = gl_Position;

	// the flat waterplane makes it easy to get vertex tangent space
	tangent = vec3(1.0,0.0,1.0);
	normalW = vec3(0.0,1.0,0.0);
	binormal = vec3(0.0,0.0,1.0);
	
	mat3 rotmat = mat3(tangent,binormal,normalW);
		
	// tangent space for view and lightvector
	
	lightDirection = vec3(pos[0]-lightpos[0],pos[1]-lightpos[1], pos[2]-lightpos[2]);
	lightDirTransformed = rotmat * normalize(lightpos);
	normalize(lightDirTransformed);

	viewingDirection= normalize(vec3(pos[0]-viewingdir[0],pos[1]-viewingdir[1], pos[2]-viewingdir[2]));
	vec3 normalizedViewingDir = normalize(viewingdir);
	viewingDirTransformed = rotmat *normalizedViewingDir; 
	normalize(viewingDirTransformed);

	
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_TexCoord[1]  = gl_MultiTexCoord1;
	gl_TexCoord[2]  = gl_MultiTexCoord2;
	gl_TexCoord[3]  = gl_MultiTexCoord3;
	

	texMat = gl_TextureMatrix[0];
	texMat1 = gl_TextureMatrix[1];
	texMat2 = gl_TextureMatrix[2];
	texMat3 = gl_TextureMatrix[3];

}

