uniform sampler2D reflectTex;
uniform sampler2D refractTex;
uniform sampler2D bumpMap;

uniform mat4 textureMatrix;
uniform mat4 textureMatrixInverse;

uniform float3 lightpos; //light position 
uniform float3 viewingdir; //viewing direction 
uniform float elapsedtime; //elapsed Time


varying vec4 pos;
varying mat4 texMat;
varying mat4 texMat1;
varying mat4 texMat2;
varying mat4 texMat3;

varying vec4 passcolor;
varying vec3 lightDirection;
varying vec3 viewingDirection;
varying vec3 lightDirTransformed;
varying vec3 viewingDirTransformed;

varying vec3 tangent;
varying vec3 binormal;
varying vec3 normalW;


void main() {
	
	vec3 T0 = gl_TexCoord[3];
	vec3 hnT0 = vec3(texture2D(bumpMap, T0.st));
	//scale lookup heightmapT0
	vec3 hnT1 = hnT0;
	hnT0 = (hnT0-0.5)*20 ;
	//hnT0.rg = (hnT0.rg-0.5)*40 ;
		
	vec3 Tn = T0;
	Tn.x = T0.x/20 + (hnT0.x );
	Tn.y = T0.y/20 + (hnT0.y);
	
	
	vec3 TnPer = T0;
	TnPer.x = T0.x + (hnT0.x );
	TnPer.y = T0.y + (hnT0.y);
	
	vec3 test = vec3(texture2D(bumpMap, Tn.st));
	
	vec4 TnRef0 = gl_TexCoord[1];
	vec4 TnRef = gl_TexCoord[1];
	
	vec4 transTn = vec4(0.0, 0.0, 0.0, 1.0);		

	//transTn.x = (hnT0.x * viewingdir.x);
	//transTn.z = (hnT0.z * viewingdir.z);
	
	transTn.x = (hnT0.x);
	transTn.z = (hnT0.z);
	
	//transTn = textureMatrixInverse * transTn;
	
	vec4 Test = TnRef0;
	Test.x = TnRef.x + transTn.x ;
	Test.z = TnRef.z + transTn.z;
	//TnRef.x = TnRef.x + transTn.x ;
	//TnRef.z = TnRef.z + transTn.z;
	
	
	TnRef =  textureMatrix * TnRef;
	
	TnRef.x = TnRef.x + transTn.x ;
	TnRef.z = TnRef.z + transTn.z;


	vec3 finalBump = vec3(texture2D(bumpMap, T0.st));
	//vec3 finalReflCol = vec3(texture2D(refractTex, Tn.st));
	//vec3 finalReflCol = vec3(texture2D(refractTex,TnRef.st));

	vec4 finalReflCol =  texture2DProj(reflectTex,TnRef);

	//vec4 testBumpColor = texture2D(bumpMap, Tn.st);

	
	float NdotL = max(dot(finalBump, lightDirTransformed), 0.0);
	vec3 diffuse = NdotL * passcolor.rgb * finalReflCol;

/////////////////////////////////////////////////////////////////////////	
	if (elapsedtime < 50.0f)
	{
		float4 speccolor;
		float3 lightSourceDir = normalize(float3(700.0,2000.0,2200.0));
		//float3 lightSourceDir = normalize(lightDirection);	
		//float3 lightSourceDir = normalize(lightpos);
		//GLfloat light1Pos[]={700.0,2000.0,3200.0, 1.0};
		
		
		vec3 viewCoord = normalize(viewingDirection);
		float3 halfvec = normalize(viewCoord+lightSourceDir+float3(hnT0.x/20, hnT0.y/20,0.0));


		float3 tempSpec = 0;
		float specPower =5;
		float dotProd = abs(dot(halfvec,normalW));
		tempSpec.x = pow(dotProd,specPower);
		speccolor = float4(0.9,0.9,0.7,0.7);
		speccolor = speccolor*tempSpec.x;
		speccolor = float4(speccolor.x*speccolor.w,speccolor.y*speccolor.w,speccolor.z*speccolor.w,0.0);
		//Output.Color = Output.Color + speccolor;

		if (speccolor.x + speccolor.y + speccolor.z + speccolor.w <0.0 ) speccolor = float4(0.0,0.0,0.0,0.0); 
		if (speccolor.x > 1.0) speccolor.x = 0.98;
		if (speccolor.y > 1.0) speccolor.y = 0.97;
		if (speccolor.z > 1.0) speccolor.z = 0.7;
		if (speccolor.w > 1.0) speccolor.w = 0.6;

		vec4 tempFinalColor = speccolor+ vec4(diffuse, 0.85) ;

		gl_FragColor =tempFinalColor;
	}
	else
	{
		gl_FragColor = vec4(diffuse, 0.85);
	
	}

}