uniform mat4 modelMatrix;
uniform mat4 lightViewProjMatrix;
uniform mat4 projectionMatrix;

varying vec4 vNormal;
varying vec4 pos;
varying vec4 lightViewPos; 

void main() {

	gl_FrontColor = gl_Color;
	
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_Position = ftransform();
	
	pos = modelMatrix * gl_Vertex;

	mat4 modelLightViewProjMatrix =  projectionMatrix * lightViewProjMatrix * modelMatrix; 
	lightViewPos = modelLightViewProjMatrix * gl_Vertex;

	vNormal.xyz = (mat3) modelMatrix * gl_Normal.xyz;
	vNormal.w = 1.0f;

}

