uniform sampler2D textureM;
uniform sampler2D depthM;

varying vec4 vNormal;
varying vec4 pos;
varying vec4 lightViewPos;

void main() {

	vec3 ct,cf;
	vec4 texel;
	float intensity,at,af;
		
	vec3 hLightViewPos = lightViewPos.xyz/lightViewPos.w;
	
	vec2 lookup;
	
	vec4 nvNormal = normalize(vNormal);
	
	// calculate slope of plane for changing bias
	float angle = acos(nvNormal.y /(sqrt(nvNormal.x*nvNormal.x+nvNormal.y*nvNormal.y+nvNormal.z*nvNormal.z)));
	float bias = 3.0f;//+angle;4.0f

	// not very smart but it works
	//if (angle > 0.1f) bias = 60.0f;
	//if (angle > 0.2f) bias = 150.f;
	
	//if (angle > 0.1f) bias = 30.0f;
	if (angle > 0.15f) bias = 60.0f;	
	if (angle > 0.2f) bias = 150.f;

	lookup.xy = ((hLightViewPos.xy)*0.5f + 0.5f);
	float distanceShadowCaster = texture2D(depthM, lookup).x;
	
	float finalFactor = 0.0f;
	
	//+++++++++++++++++++++++
	cf = (gl_FrontMaterial.diffuse).rgb; //+ gl_FrontMaterial.ambient.rgb;
	af = gl_FrontMaterial.diffuse.a;
	
	texel = texture2D(textureM,gl_TexCoord[0].st);
	ct = texel.rgb;
	at = texel.a;
		
	vec4 color = vec4(ct * cf, at * af);
	gl_FragColor = color;
	//++++++++++++++++++++++++++++++
	
	
	if(lightViewPos.w>0 && 
	   lightViewPos.z < distanceShadowCaster + bias &&	
	   abs(hLightViewPos.x)<1 && 
	   abs(hLightViewPos.y)<1) {
		
		vec4 lightPos = gl_LightSource[0].position;
		vec3 dir = pos.xyz - lightPos.xyz;
		
		dir = normalize(dir);
		vNormal.xyz = normalize(vNormal.xyz);
		
		finalFactor = max(0.0f, dot(vNormal.xyz, dir.xyz));
		

	}
	gl_FragColor = float4(color.rgb*(finalFactor+0.4f), at * af); //ambient Factor


}