/**
 * \file world.h
 *
 * \brief Main include file of the 3D world.
 *
 * \author MAxx Headroom
 * \version 0.0
 * \date 12.01.2004 21:04:13
 *
 * \todo Test the todo section.
 *
 **/


#ifndef __world_h__
#define __world_h__


#include "general.h"
#include "camera.h"
#include "exception.h"
#include "timer.h"


// VS pragmas:
//{{{
#pragma warning( disable : 4290 )
//}}}


#define WORLD_FPS_COUNT 10


//{{{ class World
/**
 * \brief Represents the whole <b>world</b>.
 *
 * Top level class of a 3d scenery. This class holds Cameras, lights and the scenery itself.
 *
 * \todo Add code.
 **/
class World
{

	private:

		Camera *cam;
		Timer timer;
		GLint lstFont;
		std::list<Object*> objects;
		typedef std::list<Object*>::iterator oIterator;

		World();

		/**
		 *
		 * \brief Print a string to the GL-window.
		 *
		 * The function works the same way as printf, aso. do.
		 *
		 * \param fmt	The format string.
		 * \param ...	Additional arguments.
		 *
		 **/
		void Print(const char *fmt, ...);

	public:

		/**
		 *
		 * \brief Create a world and also create a font.
		 *
		 * \param hDC	Device Context.
		 *
		 **/
		World(HDC hDC);
		virtual ~World();


		/**
		 *
		 * \brief All the drawing is done here.
		 *
		 * The scenery can not be drawn when the camera is not set.
		 *
		 * \exception Exception		Thrown when camera is missing.
		 *
		 **/
		void draw(bool updateFPS) throw(Exception);


		/**
		 *
		 * \brief Adds the camera to the scenery.
		 *
		 * Every scenery (i.e. world) must have a camera. If the camera
		 * is not added, the cenery can not be drawn (see also draw()).
		 *
		 * \param c	This camera will be added to the scene.
		 *
		 **/
		void addCamera(Camera *c);


		/**
		 *
		 * \brief Adds an object to the world.
		 *
		 * If the world is deleted, all added Objects will also be
		 * deleted.
		 *
		 * \param o	The object that should be added.
		 *
		 **/
		void addObject(Object *o);

	private:

		
}; /* class World */
//}}}


#endif /* __world_h__ */
