/**
 *
 * \file	timer.h
 *
 * \brief Implements a timer with a FPS function.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	24.01.2004 18:39:30
 *
 **/


#ifndef __timer_h__
#define __timer_h__


#include "general.h"


/**
 *
 * \brief Implements a timer.
 *
 **/
//{{{ Timer
class Timer
{

    private:

        LARGE_INTEGER lastTime;
        LARGE_INTEGER lastFPSTime;
        float elapsedTime;
        LARGE_INTEGER ticksPerSecond;
		bool noHiResTimer;
        int FPSFrames;
        int FPSCounter;
        float fps;


        void Init();

	public:


		Timer();
        /**
         *
         * \brief Create class and set the number for frames to count for the
         * fps.
         *
         * \param frames    Frames to count for the FPS.
         *
         **/
        Timer(int frames);
		virtual ~Timer();


		/**
		 *
		 * \brief Bevor getting a new FPS or a new MS value, the Timer
		 * must be updated.
		 *
		 **/
		void update();

		/**
		 *
		 * \brief Returns the time elapsed since the bevorlast call of
		 * update().
		 *
		 * \return	The number of milliseconds elapsed.
		 *
		 **/
		float getMS();

        /**
         *
         * \brief Returns the frames per second based on the elapsed
         * milliseconds.
         *
         * \return  The frames per seconds.
         *
         **/
		float getFPS();


}; /* Timer */
//}}}


#endif /* __timer_h__ */


// vim:fdm=marker:fdc=2:ts=4:sw=4:et:ai
