/**
 *
 * \file    timer.cc
 *
 * \brief 
 *
 * \author  MAxx Headroom
 * \version 0.0
 * \date    24.01.2004 21:12:15
 *
 **/


#include "stdafx.h"
#include "timer.h"


//{{{ Timer::Timer()
Timer::Timer()
:
    FPSFrames(10),
    FPSCounter(0),
    fps(0.0f)
{
    Init();
} /* Timer::Timer() */
//}}}


//{{{ Timer::Timer(int frames)
Timer::Timer(int frames)
:
    FPSFrames(frames),
    FPSCounter(0),
    fps(0.0f)
{
    Init();
} /* Timer::Timer(int frames) */
//}}}


//{{{ Timer::~Timer()
Timer::~Timer()
{
} /* Timer::~Timer() */
//}}}


/**
 *
 * \brief Initialize the class.
 *
 **/
//{{{ void Timer::Init()
void Timer::Init()
{
	noHiResTimer = false;
    if (!QueryPerformanceFrequency(&ticksPerSecond)) {
		noHiResTimer = true;
    } else {
        QueryPerformanceCounter(&lastTime);
        lastFPSTime = lastTime;
    }
} /* void Timer::Init() */
//}}}


//{{{ LARGE_INTEGER Timer::getMS()
float Timer::getMS()
{
	if (!noHiResTimer) {
	    LARGE_INTEGER thisTime;
        QueryPerformanceCounter(&thisTime);

        float elapsedTime = 
            ((float)thisTime.QuadPart - (float)lastTime.QuadPart) /
            (float)ticksPerSecond.QuadPart;

		return elapsedTime;
	} else {
		return 0.0;
	}
} /* LARGE_INTEGER Timer::getMS() */
//}}}


//{{{ float Timer::getFPS()
float Timer::getFPS()
{
	if (!noHiResTimer) {
		return fps;
	} else {
		return 0.0;
	}
} /* float Timer::getFPS() */
//}}}


//{{{ void Timer::update()
void Timer::update()
{

    if (!noHiResTimer) {

        QueryPerformanceCounter(&lastTime);
        ++FPSCounter;

        if (FPSCounter >= FPSFrames) {
			float elapsedTime = 
				((float)lastTime.QuadPart - (float)lastFPSTime.QuadPart) /
				(float)ticksPerSecond.QuadPart;
			fps = (float)FPSCounter / elapsedTime;
            lastFPSTime = lastTime;
            FPSCounter = 0;
        }
    }
} /* void Timer::update() */
//}}}


// vim:fdm=marker:fdc=2:ts=4:sw=4:et:ai
