/**
 *
 * \file	texture.h
 *
 * \brief Represents a texture.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	18.01.2004 11:30:52
 *
 **/
#ifndef __texture_h__
#define __texture_h__


#include "general.h"
#include "object.h"
#include "exception.h"


// VS pragmas:
//{{{
#pragma warning( disable : 4290 )
//}}}


/**
 *
 * \brief Holds one texture. The texture can be loaded from a file.
 *
 **/
//{{{ Texture
class Texture : public Object
{

	private:

		GLuint texture;
		std::string filename;


		Texture();

	public:

		Texture(std::string fn) throw(EFileNotFound);
		virtual ~Texture();

		/**
		 *
		 * \brief There is nothing to be drawn in a texture.
		 *
		 **/
		virtual void draw() {};

		GLint getTexture() throw(ENotInit);

		void setupTex();

}; /* Texture */
//}}}


//class RawTexture : public Texture {};


#endif /* __texture_h__ */


// vim:fdm=marker:fdc=2:ts=4
