/**
 *
 * \file	texture.cc
 *
 * \brief Code for the Texture class.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	18.01.2004 20:01:33
 *
 **/

#include "stdafx.h"
#include "texture.h"


/**
 *
 * \brief Default consturctor.
 *
 **/
//{{{ Texture::Texture()
Texture::Texture()
{
} /* Texture::Texture() */
//}}}


/**
 *
 * \brief Constructor sets the filename to \arg fn.
 *
 * \param fn	The filename.
 *
 **/
//{{{ Texture::Texture(std::string fn)
Texture::Texture(std::string fn) throw(EFileNotFound)
: filename(fn)
{
	FILE* f = fopen(fn.c_str(), "r");
	if (!f) throw EFileNotFound(fn);
	AUX_RGBImageRec* img=auxDIBImageLoad(filename.c_str());
	glGenTextures( 1, &texture );
	glBindTexture( GL_TEXTURE_2D, texture );
    glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
	glTexParameteri( GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR );
	glTexParameteri( GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR );
	gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, img->sizeX, img->sizeY,
					  GL_RGB, GL_UNSIGNED_BYTE, img->data);
	/*
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 
				 img->sizeX, img->sizeY, 
				 0, GL_RGB, GL_UNSIGNED_BYTE, img->data);
	*/
	if (img) {
		if (img->data) delete [] img->data;
		delete img;
	}
} /* Texture::Texture(std::string fn) */
//}}}


/**
 *
 * \brief Destructor.
 *
 **/
//{{{ Texture::~Texture()
Texture::~Texture()
{
	glDeleteTextures(1, &texture);
} /* Texture::~Texture() */
//}}}


/**
 *
 * \brief Returns the GL-name of the texture represented by this class.
 *
 * \exception ENotInit	Exception is thrown, when the texture is not yet
 *			initialized.
 *
 **/
//{{{ GLint Texture::getTexture() throw(ENotInit)
GLint Texture::getTexture() throw(ENotInit)
{
	if (!texture)
		throw ENotInit(std::string("Texture class for file '") +
			       filename);
	return texture;
} /* GLint Texture::getTexture() throw(ENotInit) */
//}}}


//{{{ void Texture::setupTex()
void Texture::setupTex()
{
	glEnable(GL_TEXTURE_2D);
	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
	glTexParameteri( GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR );
	glTexParameteri( GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR );
} /* void Texture::setupTex() */
//}}}


// vim:fdm=marker:fdc=2:ts=4
