/**
 *
 * \file	terrain.h
 *
 * \brief 
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	25.01.2004 22:41:39
 *
 **/


#ifndef __terrain_h__
#define __terrain_h__


#include "general.h"
#include "object.h"
#include "vector.h"
#include "texture.h"


/**
 *
 * \brief Creates a height field.
 *
 **/
//{{{ Terrain
class Terrain : public Object
{

	private:

		GLfloat *points;
		GLfloat height;
		vectorf pos;
		int sizeX, sizeY;
		Texture *tex;

		Terrain();

	public:

		Terrain(std::string hf, float h, Texture *t);
		virtual ~Terrain();


		void setPosition(float x, float y, float z);

		virtual void draw();

}; /* Terrain */
//}}}


#endif /* __terrain_h__ */
