/**
 *
 * \file	polygon.h
 *
 * \brief Holds the class polygon.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	18.01.2004 11:27:42
 *
 **/
#ifndef __polygon_h__
#define __polygon_h__


#include "general.h"
#include "object.h"
#include "vector.h"
#include "color.h"
#include "texture.h"


/**
 *
 * \brief This class
 *
 **/
//{{{ PPolygon
class PPolygon : public Object
{

	private:

		std::list<vectord*> vertices;
		typedef std::list<vectord*>::iterator vIterator;
		std::list<GLFColor*> colors;
		typedef std::list<GLFColor*>::iterator cIterator;
		std::list<vectord*> texPoints;
		typedef std::list<vectord*>::iterator tIterator;

		Texture *tex;
		/**
		 * Indicates, if textures or colors should be used.
		 **/
		bool texMode;

		vectord pos;


	public:

		PPolygon();
		virtual ~PPolygon();


		void addVertex(vectord& v);
		void addVertex(double x, double y, double z);
		//addColor();
		void addColor(double r, double g, double b, double a);
		void addTexture(Texture* t);
		void addTexPoint(double x, double y);

		void setPosition(double x, double y, double z);

		virtual void update(int msec);

		virtual void draw();

}; /* PPolygon */
//}}}


#endif /* __polygon_h__ */
