/**
 *
 * \file	polygon.cc
 *
 * \brief Code for the polygon class.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	20.01.2004 09:03:27
 *
 **/

#include "stdafx.h"
#include "polygon.h"


//{{{ PPolygon::PPolygon()
PPolygon::PPolygon()
: tex(0),
  texMode(false)
{
} /* PPolygon::PPolygon() */
//}}}


//{{{ PPolygon::~PPolygon()
PPolygon::~PPolygon()
{
} /* PPolygon::~PPolygon() */
//}}}


//{{{ void PPolygon::addVertex(vectord& v)
void PPolygon::addVertex(vectord& v)
{
	vertices.push_back(new vectord(v));
} /* void PPolygon::addVertex(vectord& v) */
//}}}


//{{{ void PPolygon::addVertex(double x, double y, double z)
void PPolygon::addVertex(double x, double y, double z)
{
	vertices.push_back(new vectord(x, y, z));
} /* void PPolygon::addVertex(double x, double y, double z) */
//}}}


//{{{ void PPolygon::addColor(double r, double g, double b, double a)
void PPolygon::addColor(double r, double g, double b, double a)
{
	GLFColor *c = new GLFColor;
	c->red = (GLfloat)r; c->green = (GLfloat)g; c->blue = (GLfloat)b; c->alpha = (GLfloat)a;
	colors.push_back(c);
} /* void PPolygon::addColor(double r, double g, double b, double a) */
//}}}


//{{{ void PPolygon::addTexture(Texture* t)
void PPolygon::addTexture(Texture* t)
{
	tex = t;
} /* void PPolygon::addTexture(Texture* t) */
//}}}


//{{{ void PPolygon::addTexPoint(double x, double y)
void PPolygon::addTexPoint(double x, double y)
{
	texPoints.push_back(new vectord(x, y, 0));
	texMode = (texPoints.size() == vertices.size()) && tex;
} /* void PPolygon::addTexPoint(double x, double y) */
//}}}


//{{{ void PPolygon::draw()
void PPolygon::draw()
{
	DEBUGPRINT1("void PPolygon::draw()\n");
	glPushMatrix();

	glTranslatef((GLfloat)pos.X, (GLfloat)pos.Y, (GLfloat)pos.Z);
	glPolygonMode(GL_FRONT, GL_FILL);
	if (texMode) {
		glBindTexture(GL_TEXTURE_2D, tex->getTexture());
		tex->setupTex();
	}
	glBegin(GL_POLYGON);
	cIterator ci = colors.begin();
	tIterator ti = texPoints.begin();
	for(vIterator i = vertices.begin(); i != vertices.end(); ++i) {
		if (!texMode) {
			if (ci != colors.end()) {
				glColor4f((*ci)->red, (*ci)->green, (*ci)->blue, (*ci)->alpha);
				++ci;
			}
		} else {
			if (ti != texPoints.end()) {
				glTexCoord2d((*ti)->X, (*ti)->Y);
				++ti;
			}
		}
		glVertex3d((*i)->X, (*i)->Y, (*i)->Z);
	}
	glEnd();

	glPopMatrix();
} /* void PPolygon::draw() */
//}}}


//{{{ void PPolygon::update(int msec)
void PPolygon::update(int msec)
{
	/*
	double ud;
	if (pos.Z <= 0.0) ud = -0.001;
	if (pos.Z >= -5.0) ud = 0.001;
	pos.Z += ud;
	*/
} /* void PPolygon::update(int msec) */
//}}}


//{{{ void PPolygon::setPosition(double x, double y, double z)
void PPolygon::setPosition(double x, double y, double z)
{
	pos.X = x;
	pos.Y = y;
	pos.Z = z;
} /* void PPolygon::setPosition(double x, double y, double z) */
//}}}


// vim:fdm=marker:fdc=2
