/**
 *
 * \file	object.h
 *
 * \brief Contains the class object.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	12.01.2004 22:06:00
 *
 **/


#ifndef __object_h__
#define __object_h__


#include "general.h"


/**
 * 
 * \brief All objects in the <b>world</b> are of class Object.
 *
 * This is a abstract class. Derived objects have to overwrite draw(), ...
 *
 * \todo	
 *
 **/
class Object
{

	private:

		std::list<Object*> objects;

	public:

		typedef std::list<Object*>::iterator oIterator;


	public:

		Object();
		virtual ~Object();

		virtual bool init();

		virtual void draw() = 0;

		virtual void update(int msec);

		void addObject(Object *o);

		oIterator getObjBegin();

		oIterator getObjEnd();

}; /* Object */

#endif /* __object_h__ */
