/**
 *
 * \file	object.cc
 *
 * \brief Code of the Object class.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	18.01.2004 18:38:23
 *
 **/

#include "stdafx.h"
#include "object.h"


/**
*
* \brief Default constructor.
*
**/
//{{{ Object::Object()
Object::Object()
{
} /* Object::Object() */
//}}}


/**
*
* \brief Destructor.
*
**/
//{{{ Object::~Object()
Object::~Object()
{
} /* Object::~Object() */
//}}}


/**
 *
 * \brief This method is intended to be used as a extra initialisation function
 * for the class. If initialisation code has to be done after the creation of
 * the class, it should be done here.
 *
 * \return	Indicates the success of initialisation.
 *
 **/
//{{{ bool Object::init()
bool Object::init()
{
	return true;
} /* bool Object::init() */
//}}}


/**
*
* \brief Update the objects state.
*
* This function should be called for objects which change their state
* periodically.
*
* \param \a msec	Elapsed time since last call.
*
**/
//{{{ void Object::update(int msec)
void Object::update(int msec)
{
} /* void Object::update(int msec) */
//}}}


/**
 *
 * \brief This function adds objects to this object.
 *
 * Every Object, that is added to this object, will be deleted
 * when the object itself is deleted.
 *
 * \param o	The object that should be added.
 *
 **/
//{{{ void Object::addObject(Object *o)
void Object::addObject(Object *o)
{
	objects.push_back(o);
} /* void Object::addObject(Object *o) */
//}}}


//{{{ oIterator Object::getObjBegin()
Object::oIterator Object::getObjBegin()
{
	return objects.begin();
} /* oIterator Object::getObjBegin() */
//}}}


//{{{ oIterator Object::getObjEnd()
Object::oIterator Object::getObjEnd()
{
	return objects.end();
} /* oIterator Object::getObjEnd() */
//}}}


// vim:fdm=marker
