#ifndef __horizont_h__
#define __horizont_h__


#include "general.h"
#include "vector.h"
#include "object.h"
#include "texture.h"


#define HOR_LEVEL1		0.2f
#define HOR_LEVEL2		0.6f
#define HOR_DEFAULT_R	5.0f
#define HOR_DEFAULT_SEG	8


/**
 *
 * \brief Creates a opject representing a horizon.
 *
 **/
//{{{ Horizont
class Horizont : public Object
{

	private:

		Texture*	tex;
		float		radius;
		int			segments;
		vectorf		pos;
		GLfloat*	points;
		GLfloat*	texPoints;
		GLuint*		idxStrip1;
		GLuint*		idxStrip2;
		GLuint*		idxFan;


		Horizont();

		virtual bool init();


	public:

		Horizont(Texture* t);
		Horizont(Texture* t, float r);
		Horizont(Texture* t, int seg);
		Horizont(Texture* t, float r, int seg);
		Horizont(Texture* t, float r, int seg, vectorf p);
		virtual ~Horizont();


		void setPosition(GLfloat x, GLfloat y, GLfloat z);
		void setPosition(vectord &v);


		virtual void draw();


}; /* Horizont */
//}}}


#endif /* __horizont_h__ */


// vim:fdm=marker:fdc=2:ts=4
