/*
 * gl_defs.h
 *
 */

#ifndef _GL_DEFS_H_
#define _GL_DEFS_H_


// base opengl headers

#ifndef NO_GLUT
	#include "glut.h"
#else
	#include "GL/gl.h"
#endif

// opengl extensions
#include <GL/glext.h>

// wgl extensions
#ifdef SYSTEM_WIN32
//	#include "GL/wglext.h"
#endif

// glx extensions
#ifdef SYSTEM_LINUX
	#include <GL/glxext.h>
#endif


// include individual components

#include "ro_main.h"
#include "ro_ext.h"


// low-level api wrappers

extern void GL_ActiveTexture( GLenum target );
extern void GL_BindTexture( GLenum target, GLuint texture );

extern void GL_EnableTexture( GLenum cap );
extern void GL_DisableTexture( GLenum cap );

extern void GL_EnableTexGen( GLenum cap );
extern void GL_DisableTexGen( GLenum cap );

extern void GL_EnableBlend( GLenum cap );
extern void GL_DisableBlend( GLenum cap );

extern void GL_EnableFragmentTest( GLenum cap );
extern void GL_DisableFragmentTest( GLenum cap );

extern void GL_EnableVertexShader( GLenum cap );
extern void GL_DisableVertexShader( GLenum cap );

extern void GL_EnableFragmentShader( GLenum cap );
extern void GL_DisableFragmentShader( GLenum cap );

extern void GL_EnableCullFace( GLenum cap );
extern void GL_DisableCullFace( GLenum cap );

extern void GL_ColorMask( GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha );
extern void GL_DepthMask( GLboolean flag );
extern void GL_StencilMask( GLuint mask );

extern void GL_DepthFunc( GLenum func );
extern void GL_StencilOp( GLenum fail, GLenum zfail, GLenum zpass );
extern void GL_StencilFunc( GLenum func, GLint ref, GLuint mask );

extern void GL_CullFace( GLenum mode );
extern void GL_FrontFace( GLenum mode );

extern void GL_MatrixMode( GLenum mode );
extern void GL_LoadIdentity();


#endif // _GL_DEFS_H_

