/*
 * ro_main.h
 *
 */

#ifndef _RO_MAIN_H_
#define _RO_MAIN_H_


#include "ext_general.h"
#include "ext.h"


// buffer types for read-back

enum {

	BUFFERID_COLOR,
	BUFFERID_DEPTH,
};


// pbuffer creation flags

enum {

	PBCREATE_DEFAULT	= 0x0000,
	PBCREATE_SHAREDRC	= 0x0001,		// rendering context is shared
	PBCREATE_TEXBIND	= 0x0002,		// pbuffer can be bound as texture
	PBCREATE_TEXMIPMAP	= 0x0008,		// bound texture will use mip mapping
};

enum {

	PBFORMAT_RGB		= 0,
	PBFORMAT_RGBA		= 1,

	PBFORMAT_IS_FLOAT	= 0x0100,

	PBFORMAT_FLOAT_R	= 2 | PBFORMAT_IS_FLOAT,
	PBFORMAT_FLOAT_RG	= 3 | PBFORMAT_IS_FLOAT,
	PBFORMAT_FLOAT_RGB	= 4 | PBFORMAT_IS_FLOAT,
	PBFORMAT_FLOAT_RGBA	= 5 | PBFORMAT_IS_FLOAT,
};

enum {

	PBTARGET_TEX_1D,
	PBTARGET_TEX_2D,
	PBTARGET_TEX_RECT,
	PBTARGET_TEX_CUBE,
};

struct pbuffer_create_info_s {

	dword	flags;

	word	width;
	word	height;

	word	tex_format;		// PBFORMAT_xx
	word	tex_target;		// PBTARGET_xx

	byte	bits_red;
	byte	bits_green;
	byte	bits_blue;
	byte	bits_alpha;

	byte	bits_depth;
	byte	bits_stencil;
};


// error wrapper

#define GL_ERROR() GL_QueryError( __FILE__, __LINE__ )
//#define GL_ERROR()


// external functions

void	GL_QueryError( const char *file, int line );
int		GL_ReadBuffRegion( int buffid, char *dstbuff, ugrid_t srcx, ugrid_t srcy, dword width, dword height, dword stride );

int		GL_InitPbufferHandling( int windowid );
int		GL_ActivatePbufferWindow( int windowid );

int		GL_CreatePbuffer( pbuffer_create_info_s *createinfo );

int		GL_BindPbuffer( int pbid );
int		GL_UnbindPbuffer();
int		GL_BindPbufferTexture( GLenum texunit, int pbid, int dstpbid, int dstisbound = FALSE );
int		GL_UnbindPbufferTexture( int pbid );
int		GL_DestroyPbuffer( int pbid );


#endif // _RO_MAIN_H_

