/*
 * general.h
 *
 */

#ifndef _GENERAL_H_
#define _GENERAL_H_


// determine operating system to compile for ----------------------------------
//
#ifdef _MSC_VER
	#define SYSTEM_WIN32
#else
	#define SYSTEM_LINUX
#endif


// os-dependent includes ------------------------------------------------------
//
#ifdef SYSTEM_WIN32
	#include <windows.h>
#endif


// some useful macros ---------------------------------------------------------
//
#define FALSE		0
#define TRUE		1

#define PRIVATE		static
#define PUBLIC

#ifndef GUI_QT
#define MSGOUT		SYS_MsgOut
#endif // GUI_QT

#define ALLOCMEM	malloc
#define FREEMEM		free


// assertion wrapper ----------------------------------------------------------
//
#define ASSERT		assert
#include <assert.h>


// panic functions ------------------------------------------------------------
//
#define PANIC(x)		SYS_PanicFunction( (x), __FILE__, __LINE__ )
#define OUTOFMEM(x)		SYS_OutOfMemFunction( (x), __FILE__, __LINE__ )


// panic functions ------------------------------------------------------------
//
#define CHECKALLOC(p)	if ( (p) == NULL ) OUTOFMEM(0); else {}


// type wrappers --------------------------------------------------------------
//
typedef unsigned char	byte;
typedef unsigned short	word;
typedef unsigned long	dword;

typedef long 			fixed_t;
typedef float			float_t;
typedef double			hprec_t;

typedef unsigned int	ugrid_t;
typedef int				sgrid_t;


// global includes ------------------------------------------------------------
//
//#include "gd_types.h"
//#include "gd_help.h"

//#include "glut.h"
#include "GL/gl.h"
#include "GL/glu.h"
#include "GL/glext.h"
#include <stdlib.h>
#include <stdarg.h>
#include <malloc.h>
#include <stdio.h>
//#include <time.h>
#include "wglext.h"
//#include "wglATI.h"
//#include "glATI.h"

// ----------------------------------------------------------------------------

#define PI 3.1415926535f;

// ----------------------------------------------------------------------------

#define MAX(x,y) ((x > y)? x : y)
#define MIN(x,y) ((x < y)? x : y)
#define CLAMP(x,y,z) (MAX(x,(MIN(z,y))))

// ----------------------------------------------------------------------------

extern void Fprintf( FILE *stream, const char *msg, ... );

// ----------------------------------------------------------------------------

#ifdef GUI_QT

#include "stdio.h"

extern void Printf( const char *msg, ... );

#define fprintf		Fprintf
#define MSGOUT		Printf
//#define MSGOUT		SYS_MsgOut

#endif // GUI_QT


// AGI WGL extention declarations ---------------------------------------------
#define WGL_TYPE_RGBA_FLOAT_ATI				0x21A0


// ----------------------------------------------------------------------------


#endif // _GENERAL_H_

