/**
 *
 * \file	extensions.h
 *
 * \brief Functions for managing OpenGL extensions.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	26.01.2004 09:51:20
 *
 * \todo	Make use of extension functions bullet proof, i.e. ensure that 
 *			GL_InitPBuffer is called.
 **/


#ifndef __ext_h__
#define __ext_h__


#include "ext_general.h"


/*
#ifdef __cplusplus
extern "C" {
#endif
*/


#ifdef _MSC_VER
	#define SYSTEM_WIN32
#else
	#define SYSTEM_LINUX
#endif


//FIXME:
// remove these as soon as they are defined in the official headers
typedef GLsizei GLsizeiptrARB;
typedef GLint GLintptrARB;


//wglGetCurrentDC
//wglGetCurrentContext
//wglCreateContext
//wglShareLists
//wglMakeCurrent
//wglDeleteContext
extern PFNWGLCHOOSEPIXELFORMATARBPROC wglChoosePixelFormatARB;
extern PFNWGLGETPIXELFORMATATTRIBIVARBPROC wglGetPixelFormatAttribivARB;
extern PFNWGLCREATEPBUFFERARBPROC wglCreatePbufferARB;
extern PFNWGLGETPBUFFERDCARBPROC wglGetPbufferDCARB;
extern PFNWGLBINDTEXIMAGEARBPROC wglBindTexImageARB;
extern PFNWGLRELEASETEXIMAGEARBPROC wglReleaseTexImageARB;
extern PFNWGLRELEASEPBUFFERDCARBPROC wglReleasePbufferDCARB;
extern PFNWGLDESTROYPBUFFERARBPROC wglDestroyPbufferARB;
extern PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;


/**
 * Bind the OpenGL extension functions.
 **/
extern bool GL_initPBuffer();


#endif /* __ext_h__ */
