#include "stdafx.h"
#include "ext.h"


static char *gl_ext_function_names[] = {

	// EXT_blend_color
	"glBlendColorEXT",

	// EXT_blend_func_separate
	"glBlendFuncSeparateEXT",

	// EXT_blend_minmax
	// EXT_blend_subtract
	"glBlendEquationEXT",

	// EXT_compiled_vertex_array
	"glLockArraysEXT",
	"glUnlockArraysEXT",

	// EXT_cull_vertex
	"glCullParameterfvEXT",
	"glCullParameterdvEXT",

	// EXT_paletted_texture
	"glColorTableEXT",
	"glColorSubTableEXT",
	"glGetColorTableEXT",
	"glGetColorTableParameterivEXT",
	"glGetColorTableParameterfvEXT",

	// EXT_point_parameters
	"glPointParameterfEXT",
	"glPointParameterfvEXT",

	// EXT_secondary_color
	"glSecondaryColor3bEXT",
	"glSecondaryColor3bvEXT",
	"glSecondaryColor3dEXT",
	"glSecondaryColor3dvEXT",
	"glSecondaryColor3fEXT",
	"glSecondaryColor3fvEXT",
	"glSecondaryColor3iEXT",
	"glSecondaryColor3ivEXT",
	"glSecondaryColor3sEXT",
	"glSecondaryColor3svEXT",
	"glSecondaryColor3ubEXT",
	"glSecondaryColor3ubvEXT",
	"glSecondaryColor3uiEXT",
	"glSecondaryColor3uivEXT",
	"glSecondaryColor3usEXT",
	"glSecondaryColor3usvEXT",
	"glSecondaryColorPointerEXT",

	// EXT_stencil_two_side
	"glActiveStencilFaceEXT",

	// EXT_texture3D
	"glTexImage3D",
	"glTexSubImage3D",
	"glCopyTexSubImage3D",

	// EXT_vertex_shader
    "glBeginVertexShaderEXT",
    "glEndVertexShaderEXT",
    "glBindVertexShaderEXT",
    "glGenVertexShadersEXT",
    "glDeleteVertexShaderEXT",
    "glShaderOp1EXT",
    "glShaderOp2EXT",
    "glShaderOp3EXT",
    "glSwizzleEXT",
    "glWriteMaskEXT",
    "glInsertComponentEXT",
    "glExtractComponentEXT",
    "glGenSymbolsEXT",
    "glSetInvariantEXT",
    "glSetLocalConstantEXT",
    "glVariantPointerEXT",
    "glEnableVariantClientStateEXT",
    "glDisableVariantClientStateEXT",
    "glBindLightParameterEXT",
    "glBindMaterialParameterEXT",
    "glBindTexGenParameterEXT",
    "glBindTextureUnitParameterEXT",
    "glBindParameterEXT",
    "glIsVariantEnabledEXT",
    "glGetVariantBooleanvEXT",
    "glGetVariantIntegervEXT",
    "glGetVariantFloatvEXT",
    "glGetVariantPointervEXT",
    "glGetInvariantBooleanvEXT",
    "glGetInvariantIntegervEXT",
    "glGetInvariantFloatvEXT",
    "glGetLocalConstantBooleanvEXT",
    "glGetLocalConstantIntegervEXT",
    "glGetLocalConstantFloatvEXT",

	// EXT_vertex_weighting
//	"glVertexWeightfEXT",
//	"glVertexWeightfvEXT",
//	"glVertexWeightPointerEXT",

	// ARB_fragment_program
	"glProgramStringARB",				// from ARB_vertex_program
	"glBindProgramARB",					// from ARB_vertex_program
	"glDeleteProgramsARB",				// from ARB_vertex_program
	"glGenProgramsARB",					// from ARB_vertex_program
	"glProgramEnvParameter4dARB",		// from ARB_vertex_program
	"glProgramEnvParameter4dvARB",		// from ARB_vertex_program
	"glProgramEnvParameter4fARB",		// from ARB_vertex_program
	"glProgramEnvParameter4fvARB",		// from ARB_vertex_program
	"glProgramLocalParameter4dARB",		// from ARB_vertex_program
	"glProgramLocalParameter4dvARB",	// from ARB_vertex_program
	"glProgramLocalParameter4fARB",		// from ARB_vertex_program
	"glProgramLocalParameter4fvARB",	// from ARB_vertex_program
	"glGetProgramEnvParameterdvARB",	// from ARB_vertex_program
	"glGetProgramEnvParameterfvARB",	// from ARB_vertex_program
	"glGetProgramLocalParameterdvARB",	// from ARB_vertex_program
	"glGetProgramLocalParameterfvARB",	// from ARB_vertex_program
	"glGetProgramivARB",				// from ARB_vertex_program
	"glGetProgramStringARB",			// from ARB_vertex_program
	"glIsProgramARB",					// from ARB_vertex_program

	// ARB_multitexture
	"glMultiTexCoord1fARB",
	"glMultiTexCoord2fARB",
	"glMultiTexCoord3fARB",
	"glMultiTexCoord4fARB",
	"glMultiTexCoord1fvARB",
	"glMultiTexCoord2fvARB",
	"glMultiTexCoord3fvARB",
	"glMultiTexCoord4fvARB",
	"glActiveTextureARB",
	"glClientActiveTextureARB",

	// ARB_texture_compression
	"glCompressedTexImage1DARB",
	"glCompressedTexImage2DARB",
	"glCompressedTexImage3DARB",
	"glCompressedTexSubImage1DARB",
	"glCompressedTexSubImage2DARB",
	"glCompressedTexSubImage3DARB",
	"glGetCompressedTexImageARB",

	// ARB_vertex_buffer_object
	"glBindBufferARB",
	"glDeleteBuffersARB",
	"glGenBuffersARB",
	"glIsBufferARB",
	"glBufferDataARB",
	"glBufferSubDataARB",
	"glGetBufferSubDataARB",
	"glMapBufferARB",
	"glUnmapBufferARB",
	"glGetBufferParameterivARB",
	"glGetBufferPointervARB",

	// ARB_vertex_program
    "glVertexAttrib1sARB",
    "glVertexAttrib1fARB",
    "glVertexAttrib1dARB",
    "glVertexAttrib2sARB",
    "glVertexAttrib2fARB",
    "glVertexAttrib2dARB",
    "glVertexAttrib3sARB",
    "glVertexAttrib3fARB",
    "glVertexAttrib3dARB",
    "glVertexAttrib4sARB",
    "glVertexAttrib4fARB",
    "glVertexAttrib4dARB",
    "glVertexAttrib4NubARB",
    "glVertexAttrib1svARB",
    "glVertexAttrib1fvARB",
    "glVertexAttrib1dvARB",
    "glVertexAttrib2svARB",
    "glVertexAttrib2fvARB",
    "glVertexAttrib2dvARB",
    "glVertexAttrib3svARB",
    "glVertexAttrib3fvARB",
    "glVertexAttrib3dvARB",
    "glVertexAttrib4bvARB",
    "glVertexAttrib4svARB",
    "glVertexAttrib4ivARB",
    "glVertexAttrib4ubvARB",
    "glVertexAttrib4usvARB",
    "glVertexAttrib4uivARB",
    "glVertexAttrib4fvARB",
    "glVertexAttrib4dvARB",
    "glVertexAttrib4NbvARB",
    "glVertexAttrib4NsvARB",
    "glVertexAttrib4NivARB",
    "glVertexAttrib4NubvARB",
    "glVertexAttrib4NusvARB",
    "glVertexAttrib4NuivARB",
    "glVertexAttribPointerARB",
    "glEnableVertexAttribArrayARB",
    "glDisableVertexAttribArrayARB",
	"glProgramStringARB",
	"glBindProgramARB",
	"glDeleteProgramsARB",
	"glGenProgramsARB",
	"glProgramEnvParameter4dARB",
	"glProgramEnvParameter4dvARB",
	"glProgramEnvParameter4fARB",
	"glProgramEnvParameter4fvARB",
	"glProgramLocalParameter4dARB",
	"glProgramLocalParameter4dvARB",
	"glProgramLocalParameter4fARB",
	"glProgramLocalParameter4fvARB",
	"glGetProgramEnvParameterdvARB",
	"glGetProgramEnvParameterfvARB",
	"glGetProgramLocalParameterdvARB",
	"glGetProgramLocalParameterfvARB",
	"glGetProgramivARB",
	"glGetProgramStringARB",
	"glGetVertexAttribdvARB",
    "glGetVertexAttribfvARB",
    "glGetVertexAttribivARB",
    "glGetVertexAttribPointervARB",
	"glIsProgramARB",

	// ATI_draw_buffers
	"glDrawBuffersATI",

	// ATI_fragment_shader
    "glGenFragmentShadersATI",
    "glBindFragmentShaderATI",
    "glDeleteFragmentShaderATI",
    "glBeginFragmentShaderATI",
    "glEndFragmentShaderATI",
    "glPassTexCoordATI",
    "glSampleMapATI",
    "glColorFragmentOp1ATI",
    "glColorFragmentOp2ATI",
    "glColorFragmentOp3ATI",
    "glAlphaFragmentOp1ATI",
    "glAlphaFragmentOp2ATI",
    "glAlphaFragmentOp3ATI",
    "glSetFragmentShaderConstantATI",

	// ATI_vertex_array_object
    "glNewObjectBufferATI",
    "glIsObjectBufferATI",
    "glUpdateObjectBufferATI",
    "glGetObjectBufferfvATI",
    "glGetObjectBufferivATI",
    "glDeleteObjectBufferATI",
    "glArrayObjectATI",
    "glGetArrayObjectfvATI",
    "glGetArrayObjectivATI",
    "glVariantArrayObjectATI",
    "glGetVariantArrayObjectfvATI",
    "glGetVariantArrayObjectivATI",

	// NV_fence
	"glDeleteFencesNV",
	"glGetFenceivNV",
	"glIsFenceNV",
	"glTestFenceNV",
	"glGenFencesNV",
	"glFinishFenceNV",
	"glSetFenceNV",

	// NV_fragment_program
	"glProgramNamedParameter4fNV",
	"glProgramNamedParameter4dNV",
	"glProgramNamedParameter4fvNV",
	"glProgramNamedParameter4dvNV",
	"glGetProgramNamedParameterfvNV",
	"glGetProgramNamedParameterdvNV",
	"glProgramLocalParameter4dARB",		// from ARB_vertex_program
	"glProgramLocalParameter4dvARB",	// from ARB_vertex_program
	"glProgramLocalParameter4fARB",		// from ARB_vertex_program
	"glProgramLocalParameter4fvARB",	// from ARB_vertex_program
	"glGetProgramLocalParameterdvARB",	// from ARB_vertex_program
	"glGetProgramLocalParameterfvARB",	// from ARB_vertex_program

	// NV_occlusion_query
	"glGenOcclusionQueriesNV",
	"glDeleteOcclusionQueriesNV",
	"glIsOcclusionQueryNV",
	"glBeginOcclusionQueryNV",
	"glEndOcclusionQueryNV",
	"glGetOcclusionQueryivNV",
	"glGetOcclusionQueryuivNV",

	// NV_pixel_data_range
	"glPixelDataRangeNV",
	"glFlushPixelDataRangeNV",

	// NV_point_sprite
	"glPointParameteriNV",
	"glPointParameterivNV",

	// NV_primitive_restart
	"glPrimitiveRestartNV",
	"glPrimitiveRestartIndexNV",

	// NV_register_combiners
	"glCombinerParameterfNV",
	"glCombinerParameteriNV",
	"glCombinerParameterfvNV",
	"glCombinerParameterivNV",
	"glCombinerInputNV",
	"glCombinerOutputNV",
	"glFinalCombinerInputNV",
	"glGetCombinerInputParameterfvNV",
	"glGetCombinerInputParameterivNV",
	"glGetCombinerOutputParameterfvNV",
	"glGetCombinerOutputParameterivNV",
	"glGetFinalCombinerInputParameterfvNV",
	"glGetFinalCombinerInputParameterivNV",

	// NV_register_combiners2
	"glCombinerStageParameterfvNV",
	"glGetCombinerStageParameterfvNV",

	// NV_vertex_array_range
	"glFlushVertexArrayRangeNV",
	"glVertexArrayRangeNV",

	// NV_vertex_program
	"glAreProgramsResidentNV",
	"glBindProgramNV",
	"glDeleteProgramsNV",
	"glExecuteProgramNV",
	"glGenProgramsNV",
	"glGetProgramParameterfvNV",
	"glGetProgramivNV",
	"glGetProgramStringNV",
	"glGetTrackMatrixivNV",
	"glGetVertexAttribfvNV",
	"glGetVertexAttribPointerNV",
	"glIsProgramNV",
	"glLoadProgramNV",
	"glProgramParameter4fNV",
	"glRequestResidentProgramsNV",
	"glTrackMatrixNV",
	"glVertexAttribPointerNV",
	"glVertexAttrib1fNV",
	"glVertexAttrib2fNV",
	"glVertexAttrib3fNV",
	"glVertexAttrib4fNV",
	"glVertexAttrib4ubvNV",
	"glVertexAttribs1fvNV",
	"glVertexAttribs2fvNV",
	"glVertexAttribs3fvNV",
	"glVertexAttribs4fvNV",
	"glVertexAttribs4ubvNV",

#ifdef SYSTEM_WIN32

	// ARB_buffer_region
	"wglCreateBufferRegionARB",
	"wglDeleteBufferRegionARB",
	"wglSaveBufferRegionARB",
	"wglRestoreBufferRegionARB",

	// ARB_extensions_string
//	"wglGetExtensionsStringARB",

	// ARB_make_current_read
	"wglMakeContextCurrentARB",
    "wglGetCurrentReadDCARB",

	// ARB_pbuffer
	"wglCreatePbufferARB",
	"wglGetPbufferDCARB",
	"wglReleasePbufferDCARB",
	"wglDestroyPbufferARB",
	"wglQueryPbufferARB",

	// ARB_pixel_format
	"wglGetPixelFormatAttribivARB",
	"wglGetPixelFormatAttribfvARB",
	"wglChoosePixelFormatARB",

	// ARB_render_texture
	"wglBindTexImageARB",
	"wglReleaseTexImageARB",
	"wglSetPbufferAttribARB",

	// EXT_swap_control
	"wglSwapIntervalEXT",
	"wglGetSwapIntervalEXT",

#endif // SYSTEM_WIN32

#ifdef SYSTEM_LINUX

	// GLX_SGIX_fbconfig
//	"glXGetFBConfigAttribSGIX",
//	"glXChooseFBConfigSGIX",
//	"glXCreateGLXPixmapWithConfigSGIX",
//	"glXCreateContextWithConfigSGIX",
//	"glXGetVisualFromFBConfigSGIX",
//	"glXGetFBConfigFromVisualSGIX",

	// GLX_ARB_get_proc_address
//	"glXGetProcAddressARB",

	// GLX_SGIX_pbuffer
//	"glXCreateGLXPbufferSGIX",
//	"glXDestroyGLXPbufferSGIX",
//	"glXQueryGLXPbufferSGIX",
//	"glXSelectEventSGIX",
//	"glXGetSelectedEventSGIX",

#endif // SYSTEM_LINUX

	NULL
};


PFNWGLCHOOSEPIXELFORMATARBPROC wglChoosePixelFormatARB;
PFNWGLGETPIXELFORMATATTRIBIVARBPROC wglGetPixelFormatAttribivARB;
PFNWGLCREATEPBUFFERARBPROC wglCreatePbufferARB;
PFNWGLGETPBUFFERDCARBPROC wglGetPbufferDCARB;
PFNWGLBINDTEXIMAGEARBPROC wglBindTexImageARB;
PFNWGLRELEASETEXIMAGEARBPROC wglReleaseTexImageARB;
PFNWGLRELEASEPBUFFERDCARBPROC wglReleasePbufferDCARB;
PFNWGLDESTROYPBUFFERARBPROC wglDestroyPbufferARB;
PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;


bool GL_initPBuffer()
{
	wglChoosePixelFormatARB = (PFNWGLCHOOSEPIXELFORMATARBPROC)wglGetProcAddress("wglChoosePixelFormatARB");
	wglGetPixelFormatAttribivARB = (PFNWGLGETPIXELFORMATATTRIBIVARBPROC)wglGetProcAddress("wglGetPixelFormatAttribivARB");
	wglCreatePbufferARB = (PFNWGLCREATEPBUFFERARBPROC)wglGetProcAddress("wglCreatePbufferARB");
	wglGetPbufferDCARB = (PFNWGLGETPBUFFERDCARBPROC)wglGetProcAddress("wglGetPbufferDCARB");
	wglBindTexImageARB = (PFNWGLBINDTEXIMAGEARBPROC)wglGetProcAddress("wglBindTexImageARB");
	wglReleaseTexImageARB = (PFNWGLRELEASETEXIMAGEARBPROC)wglGetProcAddress("wglReleaseTexImageARB");
	wglReleasePbufferDCARB = (PFNWGLRELEASEPBUFFERDCARBPROC)wglGetProcAddress("wglReleasePbufferDCARB");
	wglDestroyPbufferARB = (PFNWGLDESTROYPBUFFERARBPROC)wglGetProcAddress("wglDestroyPbufferARB");
	glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)wglGetProcAddress("glActiveTextureARB");

	return (wglChoosePixelFormatARB &&
			wglGetPixelFormatAttribivARB &&
			wglCreatePbufferARB &&
			wglGetPbufferDCARB &&
			wglBindTexImageARB &&
			wglReleaseTexImageARB &&
			wglReleasePbufferDCARB &&
			wglDestroyPbufferARB);
}
