/**
 *
 * \file	exception.h
 *
 * \brief All exceptions of this project are defined here.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	17.01.2004 12:28:33
 *
 **/
#ifndef __exception_h__
#define __exception_h__


#include "general.h"


/**
 *
 * \brief Base Exception class.
 *
 * All classes should be derived from this class.
 *
 **/
//{{{ Exception
class Exception
{

	private:

		std::string message;


	public:

		Exception();
		Exception(const char* msg);
		Exception(std::string msg);
		virtual ~Exception();


		void setMessage(const char* msg);
		void setMessage(std::string msg);
		std::string & getMessage();


}; /* Exception */
//}}}


/**
 *
 * \brief This exception indicates a not existing file or a file that can not
 * be read by the application.
 *
 **/
//{{{ EFileNotFound
class EFileNotFound : public Exception
{

	private:

		EFileNotFound();

	public:

		EFileNotFound(std::string filename);
		virtual ~EFileNotFound();

}; /* EFileNotFound */
//}}}


/**
 *
 * \brief This exception class indicates a not yet initialized class. The
 * string provided turing the creation should represent a class spesific text.
 *
 **/
//{{{ ENotInit
class ENotInit : public Exception
{

	private:

		ENotInit() {}

	public:

		ENotInit(std::string cl);
		virtual ~ENotInit();

}; /* ENotInit */
//}}}


#endif /* __exception_h__ */


// vim:fdm=marker
