/**
 *
 * \file	exception.cc
 *
 * \brief Code for all exceptions defined in exception.h.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	18.01.2004 18:57:59
 *
 **/


#include "stdafx.h"
#include "exception.h"



/**
 *
 * \brief Default constructor.
 *
 * \param 
 *
 **/
//{{{ Exception::Exception()
Exception::Exception()
{
} /* Exception::Exception() */
//}}}


/**
 *
 * \brief Creates a exception and sets the message to <b>char* </b><i>msg</i>
 *
 * \param msg	The message the exception should hold as <b>char*</b>.
 *
 **/
//{{{ Exception::Exception(const char* msg)
Exception::Exception(const char* msg)
{
	setMessage(msg);
} /* Exception::Exception(const char* msg) */
//}}}


/**
 *
 * \brief Creates a new exception with the std::string message <i>msg</i>.
 *
 * \param msg	The message the exception should hold as <b>string</b>.
 *
 **/
//{{{ Exception::Exception(std::string msg)
Exception::Exception(std::string msg)
{
	setMessage(msg);
} /* Exception::Exception(std::string msg) */
//}}}


/**
 *
 * \brief Does all the cleanup.
 *
 * \todo	Cleanup. 
 *
 **/
//{{{ Exception::~Exception()
Exception::~Exception()
{
} /* Exception::~Exception() */
//}}}


/**
 *
 * \brief Set the message to the <b>char*</b><i> msg</i>.
 *
 * \param msg	The message to be set.
 *
 **/
//{{{ std::string Exception::setMessage(const char* msg)
void Exception::setMessage(const char* msg)
{
	message = msg;
} /* void Exception::setMessage(const char* msg) */
//}}}


/**
 *
 * \brief Set the message to the <b>string</b><i> msg</i>.
 *
 * \param msg	The message to be set.
 *
 **/
//{{{ std::string Exception::setMessage(std::string msg)
void Exception::setMessage(std::string msg)
{
	message = msg;
} /* void Exception::setMessage(std::string msg) */
//}}}

/**
 *
 * \brief Returns the message hold by the exception.
 *
 **/
//{{{ std::string Exception::getMessage()
std::string& Exception::getMessage()
{
	return message;
} /* std::string Exception::getMessage() */
//}}}


/**
 *
 * \brief This constructor sets a error text which indicates a file error for
 * the file with the name \arg filename.
 *
 **/
//{{{ EFileNotFound::EFileNotFound(std::string filename)
EFileNotFound::EFileNotFound(std::string filename)
: Exception(std::string("The file '") + filename + std::string("' can not be accessed!"))
{
} /* EFileNotFound::EFileNotFound(std::string filename) */
//}}}


//{{{ EFileNotFound::~EFileNotFound()
EFileNotFound::~EFileNotFound()
{
} /* EFileNotFound::~EFileNotFound() */
//}}}


/**
 *
 * \brief Creates a exception with a error text which indicates that the class
 * throwing this exception is not yes initialized.
 *
 * \param cl	A string that could help the user identify the class.
 *
 **/
//{{{ ENotInit::ENotInit(std::string cl)
ENotInit::ENotInit(std::string cl)
: Exception(cl + " is not yet initialized completely!")
{
} /* ENotInit::ENotInit(std::string cl) */
//}}}


//{{{ ENotInit::~ENotInit()
ENotInit::~ENotInit()
{
} /* ENotInit::~ENotInit() */
//}}}


// vim:fdm=marker
