/**
 *
 * \file	camera.cc
 *
 * \brief Implementation of the Camera class.
 *
 * \author	MAxx Headroom
 * \version	0.0
 * \date	13.01.2004 00:57:39
 *
 **/


#include "stdafx.h"
#include "camera.h"


/**
 *
 * \brief Default constructor.
 *
 **/
//{{{
Camera::Camera()
:	consDirty(true)
{
	DEBUGPRINT1("Camera::Camera()\n");
	pos.X = 0.0;
	pos.Y = 1.0;
	pos.Z = 0.0;
	center.X = 0.0;
	center.Y = 0.0;
	center.Z = -2.0;
	up.X = 0.0;
	up.Y = 1.0;
	up.Z = 0.0;
} /* Camera::Camera() */
//}}}


Camera::Camera(int w, int h)
:
	consDirty(true),
	width(w),
	height(h)
{
	DEBUGPRINT1("Camera::Camera()\n");
	pos.X = 0.0;
	pos.Y = 1.0;
	pos.Z = 0.0;
	center.X = 0.0;
	center.Y = 0.0;
	center.Z = -2.0;
	up.X = 0.0;
	up.Y = 1.0;
	up.Z = 0.0;
} /* Camera::Camera() */
//}}}


/**
 *
 * \brief Destructor.
 *
 **/
//{{{
Camera::~Camera()
{
} /* Camera::~Camera() */
//}}}


/**
 *
 * \brief Does the drawing code for the camera.
 *
 **/
//{{{ void Camera::draw()
void Camera::draw()
{
	DEBUGPRINT1("void Camera::draw()\n");
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//gluPerspective(30.0f,(GLfloat)width/(GLfloat)height,1.0f,50.0f);
	glFrustum(-0.5*width/height, 0.5*width/height, -0.5, 0.5, 0.5, 500.0);
	gluLookAt(pos.X, pos.Y, pos.Z, 
		  center.X, center.Y, center.Z, 
		  up.X, up.Y, up.Z);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
} /* void Camera::draw() */
//}}}


/**
 *
 * \brief Sets the camera to a new position.
 *
 * \param msec	Time since the last call of update.
 *
 **/
//{{{ void Camera::update(int msec)
void Camera::update(int msec)
{
	if (pos.Y >= 2.0) movement = -0.001;
	else if (pos.Y <= 1.0) movement = 0.001;
	pos.Y += movement;
	consDirty = true;
} /* void Camera::update(int msec) */
//}}}


/**
 *
 * \brief Updates the consol vectors.
 *
 **/
//{{{ void Camera::calcConsVectors()
void Camera::calcConsVectors()
{
	vectord dir = (center - pos) * -1.0;
	dir.normal();
	DEBUGVECT2(dir);
	DEBUGVECT2(pos);
	DEBUGVECT2(up);
	vectord left = dir % up;
	DEBUGVECT2(left);
	left.normal();
	DEBUGVECT2(left);
	consRight = left * -1.0;
	DEBUGVECT2(consRight);
	consUp = dir % consRight;
	consUp.normal();
	DEBUGVECT2(consUp);
	//consUL = pos + left + consUp + dir*0.6;
	consUL = pos + left + consUp;
	consDirty = false;
} /* void Camera::calcConsVectors() */
//}}}


/**
 *
 * \brief Returns the position of the upper left corner of the console.
 *
 **/
//{{{ vectord Camera::getConsUpperLeft()
vectord Camera::getConsUpperLeft()
{
	if (consDirty) calcConsVectors();
	return consUL;
} /* vectord Camera::getConsUpperLeft() */
//}}}


/**
 *
 * \brief Returns the up vector if the console.
 *
 **/
//{{{ vectord Camera::getConsUpVect()
vectord Camera::getConsUpVect()
{
	if (consDirty) calcConsVectors();
	return consUp;
} /* vectord Camera::getConsUpVect() */
//}}}


/**
 *
 * \brief Returns the right vector of the console.
 *
 **/
//{{{ vectord Camera::getConsRightVect()
vectord Camera::getConsRightVect()
{
	if (consDirty) calcConsVectors();
	return consRight;
} /* vectord Camera::getConsRightVect() */
//}}}


// vim:fdm=marker
