#version 430 core

layout(location = 0) in vec3 position;

layout(location = 0) uniform mat4 view;
layout(location = 4) uniform mat4 projection;

out VS_OUT
{
    vec3 textureCoords;
} vs_out;

void
main()
{
    vec4 pos = projection*mat4(mat3(view))*vec4(position, 1.0f);
    gl_Position = pos.xyww;
	// On some nvidia GPUs the background starts flickering if z is to heigh.
	// This does not seem to affect intel GPUs. By subtracting a small value the
	// issue is fixed on the nvidia side and also does not effect other GPUs
    gl_Position.z = pos.w - 0.00001;
    vs_out.textureCoords = position;
}
