#version 430 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normals;
layout(location = 2) in vec2 texCoords;

layout(location = 0) uniform mat4 model;
layout(location = 4) uniform mat4 viewProjection;

out vec2 texCoordOut;

void main() 
{
	gl_Position = viewProjection * model * vec4(position, 1.0);
	texCoordOut = texCoords;
}