#version 430 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 texCoords;

out vec3 v_position;
out vec3 v_normal;
out vec2 v_uv;
out vec4 v_lightSpacePosDir;
out vec4 v_lightSpacePosSpot0;
out vec4 v_lightSpacePosSpot1;
out vec4 v_lightSpacePosSpot2;
out vec4 v_lightSpacePosSpot3;
out vec4 v_lightSpacePosSpot4;
out vec4 v_lightSpacePosSpot5;
out vec4 v_lightSpacePosSpot6;
out vec4 v_lightSpacePosSpot7;
out vec4 v_lightSpacePosSpot8;
out vec4 v_lightSpacePosSpot9;
out vec4 v_lightSpacePosSpot10;
out vec4 v_lightSpacePosSpot11;

layout(location = 0) uniform mat4 model;
layout(location = 4) uniform mat4 viewProjection;

uniform mat4 viewProjectionLightDir;
uniform mat4 viewProjectionLightSpot0;
uniform mat4 viewProjectionLightSpot1;
uniform mat4 viewProjectionLightSpot2;
uniform mat4 viewProjectionLightSpot3;
uniform mat4 viewProjectionLightSpot4;
uniform mat4 viewProjectionLightSpot5;
uniform mat4 viewProjectionLightSpot6;
uniform mat4 viewProjectionLightSpot7;
uniform mat4 viewProjectionLightSpot8;
uniform mat4 viewProjectionLightSpot9;
uniform mat4 viewProjectionLightSpot10;
uniform mat4 viewProjectionLightSpot11;

void main()
{
	v_position = (model * vec4(position, 1)).xyz;
	v_normal = mat3(transpose(inverse(model))) * normal;
	v_uv = texCoords;
	v_lightSpacePosDir = viewProjectionLightDir * model * vec4(position, 1);
	v_lightSpacePosSpot0 = viewProjectionLightSpot0 * model * vec4(position, 1);
	v_lightSpacePosSpot1 = viewProjectionLightSpot1 * model * vec4(position, 1);
	v_lightSpacePosSpot2 = viewProjectionLightSpot2 * model * vec4(position, 1);
	v_lightSpacePosSpot3 = viewProjectionLightSpot3 * model * vec4(position, 1);
	v_lightSpacePosSpot4 = viewProjectionLightSpot4 * model * vec4(position, 1);
	v_lightSpacePosSpot5 = viewProjectionLightSpot5 * model * vec4(position, 1);
	v_lightSpacePosSpot6 = viewProjectionLightSpot6 * model * vec4(position, 1);
	v_lightSpacePosSpot7 = viewProjectionLightSpot7 * model * vec4(position, 1);
	v_lightSpacePosSpot8 = viewProjectionLightSpot8 * model * vec4(position, 1);
	v_lightSpacePosSpot9 = viewProjectionLightSpot9 * model * vec4(position, 1);
	v_lightSpacePosSpot10 = viewProjectionLightSpot10 * model * vec4(position, 1);
	v_lightSpacePosSpot11 = viewProjectionLightSpot11 * model * vec4(position, 1);
	gl_Position = viewProjection * model * vec4(position, 1);
}
