#version 430 core

in vec3 v_position;
in vec3 v_normal;
in vec2 v_uv;
in vec4 v_lightSpacePosDir;
in vec4 v_lightSpacePosSpot0;
in vec4 v_lightSpacePosSpot1;
in vec4 v_lightSpacePosSpot2;
in vec4 v_lightSpacePosSpot3;
in vec4 v_lightSpacePosSpot4;
in vec4 v_lightSpacePosSpot5;
in vec4 v_lightSpacePosSpot6;
in vec4 v_lightSpacePosSpot7;
in vec4 v_lightSpacePosSpot8;
in vec4 v_lightSpacePosSpot9;
in vec4 v_lightSpacePosSpot10;
in vec4 v_lightSpacePosSpot11;

layout (location = 0) out vec3 gPosition;
layout (location = 1) out vec3 gNormal;
layout (location = 2) out vec4 gAlbedoShine;
layout (location = 3) out vec4 gKaSpecR;
layout (location = 4) out vec4 gKdSpecG;
layout (location = 5) out vec4 gKsSpecB;
layout (location = 6) out vec3 gShadowDir;
layout (location = 7) out vec3 gShadowSpot;

uniform struct object_material {
    sampler2D ambient;
    sampler2D diffuse;
    sampler2D specular;

    vec3 ka, kd, ks;

    float shininess;
} material;

uniform sampler2D gShadowMapDir;
uniform sampler2D gShadowMapSpot0;
uniform sampler2D gShadowMapSpot1;
uniform sampler2D gShadowMapSpot2;
uniform sampler2D gShadowMapSpot3;
uniform sampler2D gShadowMapSpot4;
uniform sampler2D gShadowMapSpot5;
uniform sampler2D gShadowMapSpot6;
uniform sampler2D gShadowMapSpot7;
uniform sampler2D gShadowMapSpot8;
uniform sampler2D gShadowMapSpot9;
uniform sampler2D gShadowMapSpot10;
uniform sampler2D gShadowMapSpot11;
uniform vec2 gMapSizeDir;
uniform vec2 gMapSizeSpot;

#define EPSILON 0.00001


// Calculates the shadow factor
// Returns 0, if the pixel is in shadow
// Returns 1, if the pixel is not in shadow
float calcShadowFactor(vec4 lightSpacePos, sampler2D shadowMap, vec2 mapSize)
{
    vec3 projCoords = lightSpacePos.xyz / lightSpacePos.w;
    vec2 uvCoords;
    uvCoords.x = 0.5 * projCoords.x + 0.5;
    uvCoords.y = 0.5 * projCoords.y + 0.5;
    float z    = 0.5 * projCoords.z + 0.5;

    float xOffset = 1.0 / mapSize.x;
    float yOffset = 1.0 / mapSize.y;

    float factor = 0.0;

    for (int y = -2; y <= 2; y++) {
        for (int x = -2; x <= 2; x++) {
            vec2 offsets = vec2(x * xOffset, y * yOffset);
            vec2 uvOffset = uvCoords + offsets;

            if (uvOffset.x < 0.0 || uvOffset.x > 1.0 || uvOffset.y < 0.0 || uvOffset.y > 1.0) {
                factor += 1.0;
            } else {
                float depth = texture(shadowMap, uvCoords + offsets).x;
                factor += depth < z - EPSILON ? 0.0 : 1.0;
            }
        }
    }

    return (factor / 25.0);
}

void main()
{
    gPosition = v_position;
    gNormal = v_normal;
    gAlbedoShine.rgb = texture(material.diffuse, v_uv).rgb;
    // convert shininess to [0, 1] range else it get's clamped to that range
    // because of the color texture format. Since we provide the models, assume
    // our shininess range is [0, 100]
    gAlbedoShine.a = material.shininess/100.0;
    gKaSpecR = vec4(material.ka, texture(material.specular, v_uv).r);
    gKdSpecG = vec4(material.kd, texture(material.specular, v_uv).g);
    gKsSpecB = vec4(material.ks, texture(material.specular, v_uv).b);

    gShadowDir = vec3(calcShadowFactor(v_lightSpacePosDir, gShadowMapDir, gMapSizeDir));
    gShadowSpot = vec3(min(min(min(min(min(min(min(min(min(min(min(min(
        calcShadowFactor(v_lightSpacePosSpot0, gShadowMapSpot0, gMapSizeSpot),
        calcShadowFactor(v_lightSpacePosSpot1, gShadowMapSpot1, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot2, gShadowMapSpot2, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot3, gShadowMapSpot3, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot4, gShadowMapSpot4, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot5, gShadowMapSpot5, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot6, gShadowMapSpot6, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot7, gShadowMapSpot7, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot8, gShadowMapSpot8, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot9, gShadowMapSpot9, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot10, gShadowMapSpot10, gMapSizeSpot)),
        calcShadowFactor(v_lightSpacePosSpot11, gShadowMapSpot11, gMapSizeSpot)),
        1.0));
}
