#version 430 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normals;
layout(location = 2) in vec2 texCoords;

out vec3 v_position;
out vec3 v_normals;
out vec2 v_uv;
out vec4 v_lightSpacePos;

layout(location = 0) uniform mat4 model;
layout(location = 4) uniform mat4 viewProjection;
uniform mat4 viewProjectionLight;

void main()
{
	v_position = (model * vec4(position, 1)).xyz;
	v_normals = (model * vec4(normals, 0)).xyz;
	v_uv = texCoords;
	v_lightSpacePos = viewProjectionLight * model * vec4(position, 1);
	gl_Position = viewProjection * model * vec4(position, 1);
}
