#version 330 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 textCoord;
layout(location = 3) in vec3 tangent;

out vec3 o_position;
out vec2 o_textCoord;
out mat3 o_tbnMat;

uniform mat4 modelViewProjMat;
uniform mat4 modelViewMat;
uniform mat4 inverseModelViewMat;

void main() {
    gl_Position = modelViewProjMat * vec4(position, 1.0f);
	o_position = vec3(modelViewMat * vec4(position, 1.0f));
	o_textCoord = textCoord;

	vec3 n = normalize(mat3(inverseModelViewMat) * normal); // normal on texture
	vec3 t = normalize(mat3(inverseModelViewMat) * tangent); // tangent (u-axis) on texture
	t = normalize(t - dot(n, t) * n);
	vec3 b = normalize(cross(n, t)); // bitangent (v-axis) on texture
	o_tbnMat = mat3(t, b, n); // https://wiki.delphigl.com/index.php/TBN_Matrix
}