#version 330 core

layout(location = 0) out vec4 fragColor;

in vec3 o_position;
in vec2 o_textCoord;
in mat3 o_tbnMat;

struct Material {
	vec3 diffuse;
	vec3 specular;
	vec3 emissive;
	float shininess;
};

struct DirectLight {
	vec3 direction;
	vec3 ambient;
};

struct PointLight {
	vec3 position;
	vec3 color;

	float linear;
	float quadratic;
};

uniform Material material;
uniform DirectLight directLight;
uniform PointLight pointLight;
uniform sampler2D texture_diffuse1;
uniform sampler2D texture_normal1;
uniform sampler2D texture_specular1;

void main() {
	// need all illuminations
	vec3 viewVec = normalize(-o_position);

	// normal from normal map
	vec3 normal = normalize(o_tbnMat * (2.0 * texture2D(texture_normal1, o_textCoord).rgb - 1.0));

	// texture
	vec4 diffuseColor = texture(texture_diffuse1, o_textCoord);
	vec4 specularIntensity = texture(texture_specular1, o_textCoord);

	// direction illumination
	vec3 light = normalize(-directLight.direction);
	vec3 reflection = reflect(-light, normal);
	vec3 ambient = directLight.ambient * diffuseColor.xyz;
	vec3 diffuse = max(dot(normal, light), 0.0) * diffuseColor.xyz;
	vec3 specular = pow(max(dot(reflection, viewVec), 0.0), material.shininess) * material.specular * specularIntensity.xyz;

	// point illumination (http://wiki.ogre3d.org/-Point+Light+Attenuation)
	vec3 pointLightDirection = normalize(pointLight.position - o_position);
	reflection = reflect(-pointLightDirection, normal);
	float dist = length(pointLight.position - o_position);
	float attenuation = 1.0 / (1.0 + pointLight.linear * dist + pointLight.quadratic * pow(dist, 2.0f));
	diffuse += max(dot(normal, pointLightDirection), 0.0) * diffuseColor.xyz * attenuation;
	specular += pow(max(dot(reflection, viewVec), 0.0), material.shininess) * material.specular * specularIntensity.xyz * attenuation;

	vec3 lighting  = ambient + diffuse + specular + material.emissive;

	fragColor = vec4(lighting, 1.0);
}