#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexCoords;
layout (location = 3) in vec3 aTangent;

out vec3 FragPos;
out vec2 TexCoords;
out mat3 vert_tbnMat;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main()
{
    // FragPos and Normal are in view space
    vec4 viewPos = view * model * vec4(aPos, 1.0);
    FragPos = viewPos.xyz;
    TexCoords = aTexCoords;

    mat3 normalMatrix = mat3(transpose(inverse(view * model)));

    vec3 n = normalize(normalMatrix * aNormal); // normal on texture
    vec3 t = normalize(normalMatrix * aTangent); // tangent (u-axis) on texture
    t = normalize(t - dot(n, t) * n);
    vec3 b = normalize(cross(n, t)); // bitangent (v-axis) on texture
    vert_tbnMat = mat3(t, b, n);

    gl_Position = projection * viewPos;
}
