#version 330 core
layout (triangles) in;
layout (triangle_strip, max_vertices=18) out;

uniform mat4 shadowTransformMats[6];

out vec4 FragPos;

void main() {
	for (int face = 0; face < 6; ++face) {
		gl_Layer = face; // gl_Layer is a built-in variable that specifies to which cubmap face the primitive is rendered
		for (int triangleVert = 0; triangleVert < 3; ++triangleVert) {
			FragPos = gl_in[triangleVert].gl_Position;
			gl_Position = shadowTransformMats[face] * FragPos;
			EmitVertex(); // emit a vertex to the first vertex stream
		}
		EndPrimitive(); // complete the current output primitive on the first vertex stream
	}
}