#version 330 core

layout(location = 0) out vec4 fragColor;

in vec3 o_position;
in vec2 o_textCoord;
in mat3 o_tbnMat;

struct Material {
	vec3 diffuse;
	vec3 specular;
	vec3 emissive; //for self-illuminating objects
	float shininess;
};

struct DirectLight {
	vec3 direction;

	vec3 diffuse;
	vec3 specular;
	vec3 ambient;
};

struct PointLight {
	vec3 position;

	vec3 diffuse;
	vec3 specular;
	vec3 ambient;

	float linear;
	float quadratic;
	float constant;
};

struct SpotLight {
	vec3 position;
	vec3 direction; //normalized vector!

	float outerCone;
	float innerCone;

	vec3 diffuse;
	vec3 specular;
	vec3 ambient;

	float linear;
	float quadratic;
	float constant;
};

uniform Material u_material;
uniform DirectLight u_directLight;
uniform PointLight u_pointLight;
uniform SpotLight u_spotLight;
uniform sampler2D u_diffuseMap;
uniform sampler2D u_normalMap;

void main() {
	//need all illuminations
	vec3 viewVec = normalize(-o_position); //Vector from fragment to camera (camera always at 0, 0, 0)

	//normal from normal map
	vec3 normal = texture(u_normalMap, o_textCoord).rgb;
	normal = normalize(normal * 2.0 - 1.0);
	normal = normalize(o_tbnMat * normal);

	//texture
	vec4 diffuseColor = texture(u_diffuseMap, o_textCoord);
	if (diffuseColor.w < 0.9) {
		discard;
	}

	//direction illumination
	vec3 light = normalize(-u_directLight.direction);
	vec3 reflection = reflect(-light, normal);
	vec3 ambient = u_directLight.ambient * diffuseColor.xyz;
	vec3 diffuse = u_directLight.diffuse * max(dot(normal, light), 0.0) * diffuseColor.xyz;
	vec3 specular = u_directLight.specular * pow(max(dot(reflection, viewVec), 0.000001), u_material.shininess) * u_material.specular;

	//point illumination (http://wiki.ogre3d.org/-Point+Light+Attenuation)
	vec3 pointLightDirection = normalize(u_pointLight.position - o_position);
	//reflection = reflect(-light, normal);
	float dist = length(u_pointLight.position - o_position);
	float attenuation = 1.0 / (u_pointLight.constant + (u_pointLight.linear * dist) + (u_pointLight.quadratic * pow(dist,2.0f)));
	//ambient += attenuation * u_pointLight.ambient * diffuseColor.xyz;
	diffuse += u_pointLight.diffuse * max(dot(normal, pointLightDirection), 0.0) * diffuseColor.xyz;
	//specular += attenuation * u_pointLight.specular * pow(max(dot(reflection, viewVec), 0.00000001), u_material.shininess) * u_material.specular;

	//spot illumination
	/* light = normalize(u_spotLight.position - o_position);
	reflection = reflect(-light, normal);
	dist = length(u_spotLight.position - o_position);
	attenuation = 1.0 / (u_spotLight.constant + (u_spotLight.linear * dist) + (u_spotLight.quadratic * pow(dist,2.0f)));
	float angle = dot(light, u_spotLight.direction);
	float intermediate  = u_spotLight.innerCone - u_spotLight.outerCone;
	float intensity = clamp((angle - u_spotLight.outerCone) / intermediate, 0.0, 1.0); //clamp: no value smaller 0.0 and greater 1.0
	if (angle > u_spotLight.outerCone) {
		ambient += attenuation * u_spotLight.ambient * diffuseColor.xyz;
		diffuse += attenuation * intensity * u_spotLight.diffuse * max(dot(normal, light), 0.0) * diffuseColor.xyz;
		specular += attenuation * intensity * u_spotLight.specular * pow(max(dot(reflection, viewVec), 0.000001), u_material.shininess) * u_material.specular;
	} else {
		ambient += attenuation * u_spotLight.ambient * diffuseColor.xyz;
	} */

	//fragColor = vec4(ambient + diffuse + specular + u_material.emissive, 1.0);
	fragColor = vec4(ambient + diffuse, 1.0);
}