#version 400

layout(quads) in;

const int NUM_CASCADES = 3;

patch in vec4 pos[4];

//layout(location = 0) in vec3 vertexPosition_modelspace;
//layout(location = 1) in vec2 vertexUV;

in vec2 texCoord_ce[];

out vec2 texcoord;

uniform bool depthRendering;
uniform mat4 MVP;
uniform mat4 V;
uniform mat4 M;
uniform mat4 prevMVP;
uniform vec3 LightPosition_worldspace;
uniform sampler2DRect displacementMap;
uniform sampler2DRect normalMap;

out vec2 UV;
out vec3 Position_worldspace;
out vec3 Normal_cameraspace;
out vec3 Normal_worldspace;
out vec3 EyeDirection_cameraspace;
out vec3 LightDirection_cameraspace;
out vec3 Position_cameraspace;

//uniform mat4 DepthBiasMVP;
uniform mat4 DepthBiasMVP[NUM_CASCADES];
//out vec4 ShadowCoord;
out vec4 ShadowCoord[NUM_CASCADES];
out float ClipSpacePosZ;

out vec4 positionView;
out vec4 prevPositionView;

void main()
{
   float u = gl_TessCoord.x;
   float v = gl_TessCoord.y;

   vec4 p = (pos[2] * u + pos[3] * (1 - u)) * v + 
	(pos[1] * u + pos[0] * (1 - u)) * (1 - v);

   vec2 uv = (texCoord_ce[1] * u + texCoord_ce[0] * (1 - u)) * (1 - v) + 
   		(texCoord_ce[2] * u + texCoord_ce[3] * (1 - u)) * v;

   //texcoord = uv;

   ivec2 v3 = ivec2(p.x, p.z);

   vec4 bump = texelFetch(displacementMap, v3);	
	   
   p.y = bump.x;

	gl_Position = MVP * p;

	if (!depthRendering)
	{
	// for shadow mapping

	//vec3 vertexNormal_modelspace = texelFetch(normalMap, v3).xyz;
	Normal_worldspace = texelFetch(normalMap, v3).xyz;
//	vertexNormal_modelspace = vec3(0, 1, 0);
	vec3 vertexPosition_modelspace = p.xyz;
	
	// Output position of the vertex, in clip space : MVP * position
	positionView =  MVP * vec4(vertexPosition_modelspace,1);
	prevPositionView = prevMVP * vec4(vertexPosition_modelspace,1);

	//gl_Position = positionView;

	//ShadowCoord[0] = DepthBiasMVP[0] * M * vec4(vertexPosition_modelspace,1);
    //ShadowCoord = DepthBiasMVP * vec4(vertexPosition_modelspace,1);
	for (int i = 0 ; i < NUM_CASCADES ; i++) {
        ShadowCoord[i] = DepthBiasMVP[i] * vec4(vertexPosition_modelspace,1);
    }
	ClipSpacePosZ = vertexPosition_modelspace.z;
	
	// Position of the vertex, in worldspace : M * position
	Position_worldspace = (M * vec4(vertexPosition_modelspace,1)).xyz;
	
	// Vector that goes from the vertex to the camera, in camera space.
	// In camera space, the camera is at the origin (0,0,0).
	vec3 vertexPosition_cameraspace = ( V * M * vec4(vertexPosition_modelspace,1)).xyz;
	Position_cameraspace = vertexPosition_cameraspace;
	EyeDirection_cameraspace = vec3(0,0,0) - vertexPosition_cameraspace;

	// Vector that goes from the vertex to the light, in camera space. M is ommited because it's identity.
	vec3 LightPosition_cameraspace = ( V * vec4(LightPosition_worldspace,1)).xyz;
	LightDirection_cameraspace = LightPosition_cameraspace + EyeDirection_cameraspace;
	
	// Normal of the the vertex, in camera space
	//Normal_cameraspace = ( V * M * vec4(vertexNormal_modelspace,0)).xyz; 
	Normal_cameraspace = ( V * vec4(Normal_worldspace,0)).xyz; 
// Only correct if ModelMatrix does not scale the model ! Use its inverse transpose if not.
	
	//Normal_worldspace = (M*vec4(vertexNormal_modelspace,0)).xyz;

	// UV of the vertex. No special space for this one.
	UV = uv;
	}
}
