﻿#version 330 core

out vec4 FragColor;
in vec2 interpolatedTextureCoordinate;
uniform sampler2D screenTexture;

void main()
{ 
	const float gamma = 2.2;
    vec3 color = texture(screenTexture, interpolatedTextureCoordinate).rgb;
    vec3 rtm = color / (color + vec3(1.0)); // reinhard tone mapping
    rtm = pow(rtm, vec3(1.0 / gamma)); // gamma correction 
    FragColor = vec4(rtm, 1.0);
}