﻿#version 430 core

layout (location = 0) in vec4 position;
layout (location = 1) in vec2 uvCoordinate;
layout (location = 2) in vec3 normal;

uniform  mat4 modelViewProjectionMatrix;
uniform  mat4 modelMatrix;
uniform vec3 lightPos;
uniform vec3 cameraPos;

out vec2 interpolatedUVCoordinate;
out vec3 interpolatedNormal;
out vec3 interpolatedLightDirection;
out vec3 interpolatedCameraDirection;
out vec3 interpolatedFragPos;

void main(void)
{
	// camera space
	vec4 worldPos = (modelMatrix * position);

	// directions
	interpolatedNormal	= normalize(mat3(modelMatrix) * normal.xyz);
	interpolatedLightDirection	= normalize(lightPos - worldPos.xyz);
	interpolatedCameraDirection	= normalize(cameraPos - worldPos.xyz);
	interpolatedFragPos = vec3(worldPos);

	// uv space
	interpolatedUVCoordinate = uvCoordinate;

	// screen space
	gl_Position	= modelViewProjectionMatrix * position;
}