﻿#version 420
##includeCommonVertFunctions##

uniform sampler2D posTex;
uniform sampler2D velTex;
uniform sampler2D nnCountTex;
uniform sampler2D nnVelTex;
uniform sampler2D nnPosTex;

uniform int nnTexWidth;
uniform int cubeRes;

uniform mat4 mvp;

out vec3 color;

void main() {
	vec2 texPos = getPhysTextureSpacePosition(gl_VertexID, textureSize(posTex, 0).x);  

	vec3 pos = texture(posTex, texPos).rgb;
	vec3 vel = texture(velTex, texPos).rgb;

	vec2 nnTexPos = getNNGridTexCoords(pos, vec3(-0.5, 0, -0.5), vec3(1.0, 1.0, 1.0), cubeRes, nnTexWidth);

	float neighbourCount = texture(nnCountTex, nnTexPos).r;
	vec3 nnVel =  texture(nnVelTex, nnTexPos).rgb / neighbourCount;
	vec3 nnPos =  texture(nnPosTex, nnTexPos).rgb / neighbourCount;

	color.r = 1.0;
	color.bg = texPos;

	vec4 trPos = mvp*vec4(pos, 1.0);
	trPos /= trPos.w;

	// transform to according position
	gl_Position = trPos;
}