﻿#version 420
##includeCommonVertFunctions##

uniform sampler2D posTex;
uniform sampler2D velTex;

uniform int texWidth;
uniform int cubeRes;

out vec3 outVel;
out vec3 outPos;

void main() {
	vec2 texPos = getPhysTextureSpacePosition(gl_VertexID, texWidth);  
	vec3 pos = texture(posTex, texPos).rgb;
	vec3 vel = texture(velTex, texPos).rgb;

	vec2 renderPos = getNNGridTextureSpacePosition(pos, vec3(-.5, 0, -.5), vec3(1.0, 1.0, 1.0), cubeRes, texWidth);

	outVel = vel;
	outPos = pos;

	gl_Position = vec4(renderPos, 0, 1.0);
}